function xnew = gaussseidel_step(A, b, xold);

[p, n] = size(A);
if not(p==n) || not(length(b)==n) || not(length(xold)==n) 
    error('dimensioni');
end
xnew = zeros(n,1);
for i = 1:n
   somma1 = 0;
   for j = 1:i-1
       somma1 = somma1 + A(i,j)*xnew(j);
   end
   somma2 = 0;
   for j = i+1:n
       somma2 = somma2 + A(i,j)*xold(j);
   end
   xnew(i) = (b(i) - somma1 - somma2) / A(i,i); 
end
